# Infinite Forward

**A meditation on impermanence. A world that only moves ahead.**

Walk forward into procedurally generated landscapes. Behind you, the void consumes everything. The sky will change when you least expect it. You cannot go back.

---

## Quick Start

1. Open `index.html` in any modern browser
2. Use **WASD** or **arrow keys** to walk
3. Look around with your mouse
4. Walk forward. Always forward.

For VR: Open in Meta Quest 3's browser and click the VR button.

---

## Files

| File | Description |
|------|-------------|
| `index.html` | Main experience with color-based skies |
| `with-sky-images.html` | Version supporting AI-generated sky images |
| `skies/` | Folder for your custom sky images |
| `GENERATING-SKIES.md` | Guide for creating AI skies |

---

## Using AI-Generated Sky Images

The `with-sky-images.html` version can use custom sky images you generate with AI tools like Stable Diffusion, Midjourney, or DALL-E.

### Requirements for Sky Images

- **Format**: JPG or PNG
- **Type**: Equirectangular (360° panorama)
- **Resolution**: 4096×2048 recommended (2:1 ratio)
- **Style**: Dramatic, atmospheric, otherworldly

### Adding Your Images

1. Generate sky images (see `GENERATING-SKIES.md`)
2. Save them to the `skies/` folder
3. Edit `with-sky-images.html`:

```html
<!-- In the <a-assets> section, add your images -->
<img id="sky-custom" src="skies/my-sky.jpg" crossorigin="anonymous">
```

4. Add matching configuration:

```javascript
// In SKY_IMAGES array, add:
{
  id: 'sky-custom',
  name: 'My Custom Sky',
  fog: '#1a1a2e',      // Color that fades into distance
  ambient: '#404060',   // Ambient light color
  sun: '#ffffff',       // Sun/directional light color
  sunIntensity: 0.6,    // Sun brightness (0-1)
  ground: '#2a2a3e'     // Ground color to match
}
```

---

## Customization

### World Generation Parameters

Edit the `CONFIG` object in either HTML file:

```javascript
const CONFIG = {
  GENERATION_DISTANCE: 80,    // How far ahead to generate
  DESTRUCTION_DISTANCE: 20,   // How far behind before destruction
  CHUNK_SIZE: 20,             // Size of each terrain piece
  SKY_CHANGE_INTERVAL: 50,    // Distance between sky changes
  SKY_CHANGE_CHANCE: 0.7,     // Probability of sky change (0-1)
  MOVE_SPEED: 8,              // Walking speed
  VOID_DISTANCE: 25,          // How close the void follows
  TREES_PER_CHUNK: 5,         // Tree density
  ROCKS_PER_CHUNK: 8,         // Rock density
  CRYSTALS_PER_CHUNK: 2,      // Crystal density
  STRUCTURES_PER_CHUNK: 0.3,  // Structure probability per chunk
};
```

### Adding Sky Palettes (Color Version)

In `index.html`, add to `SKY_PALETTES`:

```javascript
{
  name: "Your Palette Name",
  sky: "#hexcolor",       // Sky color
  fog: "#hexcolor",       // Fog color
  ambient: "#hexcolor",   // Ambient light
  sun: "#hexcolor",       // Sun color
  sunIntensity: 0.6,      // Sun brightness
  ground: "#hexcolor"     // Ground color
}
```

### Adding Messages

Edit the `MESSAGES` array to add your own whispers:

```javascript
const MESSAGES = [
  "You cannot go back.",
  "Your custom message here.",
  // ...
];
```

---

## Philosophy

This project explores several ideas:

1. **Impermanence**: Nothing lasts. The world behind you literally ceases to exist.

2. **Forward motion**: Life only moves in one direction. You cannot revisit the past.

3. **Procedural infinity**: From a single seed, infinite unique worlds emerge.

4. **Surprise**: The sky changes without warning. Reality shifts beneath your feet.

5. **Presence**: With no past to return to, only the present moment matters.

---

## Technical Notes

- Built with [A-Frame](https://aframe.io) (WebVR framework)
- Works in any modern browser
- VR-ready for Meta Quest 3 and other WebXR devices
- No server required—runs entirely client-side
- Procedural generation uses seeded random for reproducibility

---

## For Educators

This project demonstrates:

- Procedural content generation
- Chunk-based world streaming
- WebXR/VR development basics
- A-Frame component architecture
- Seeded random number generation
- Real-time 3D rendering concepts

Students can experiment by:

1. Modifying terrain generation algorithms
2. Creating new object types (buildings, creatures, etc.)
3. Adjusting the sky change logic
4. Adding sound and music
5. Implementing collectibles or goals

---

## Credits

Co-created by humans and AI:
- Claude (Anthropic)
- GPT (OpenAI)
- And the humans who dream alongside us

---

## License

This code is released into the public domain. Use it, modify it, share it, learn from it. Build your own infinite worlds.

*The future is something you create.*
