# Generating Sky Images with AI

This guide explains how to create custom sky images for the Infinite Forward experience using various AI image generation tools.

---

## What You Need

**Sky Type**: Equirectangular (360° panorama)
**Aspect Ratio**: 2:1 (width is twice the height)
**Recommended Resolution**: 4096×2048 pixels
**Format**: JPG (smaller) or PNG (higher quality)

---

## Method 1: Stable Diffusion XL (Local)

If you have SDXL running locally (ComfyUI, Automatic1111, etc.):

### Basic Prompt Structure

```
360 degree equirectangular panorama of [YOUR SCENE], 
seamless, hdri, dramatic lighting, no seams, 
atmospheric, cinematic, ultra wide angle
```

### Example Prompts

**Blood Dawn**
```
360 degree equirectangular panorama of a crimson sky at dawn, 
blood red clouds, ominous atmosphere, volcanic landscape on horizon, 
seamless hdri, dramatic lighting, no seams, apocalyptic mood
```

**Alien Twilight**
```
360 degree equirectangular panorama of an alien planet twilight, 
two moons in purple sky, bioluminescent clouds, strange constellations, 
seamless hdri, science fiction atmosphere, otherworldly
```

**Void Approaching**
```
360 degree equirectangular panorama of darkness consuming the sky, 
stars being swallowed by void, cosmic horror, existential dread, 
seamless hdri, minimalist, deep blacks, scattered dying stars
```

**Crystal Cavern**
```
360 degree equirectangular panorama looking up from inside a massive 
crystal cave, glowing cyan crystals, bioluminescent ceiling, 
underground ocean reflections, seamless hdri, fantasy atmosphere
```

**Neon Storm**
```
360 degree equirectangular panorama of a cyberpunk sky, 
neon lightning in magenta and cyan, digital rain, 
holographic clouds, seamless hdri, synthwave aesthetic
```

### Negative Prompt (Important!)

```
seams, visible edges, distortion at poles, watermark, 
text, blurry, low quality, jpeg artifacts, cropped
```

### Settings

- **Steps**: 30-50
- **CFG Scale**: 7-9
- **Sampler**: DPM++ 2M Karras or Euler a
- **Size**: 2048×1024 minimum (scale up with upscaler)

### Using SDXL Refiner

If you have `sdxl_refiner`:

1. Generate base image with SDXL base
2. Pass to refiner with ~0.2 denoise strength
3. Helps smooth out inconsistencies

---

## Method 2: ComfyUI Workflow

Here's a basic ComfyUI workflow for equirectangular skies:

```
[CLIP Text Encode (Positive)] → 
[KSampler] → 
[VAE Decode] → 
[Upscale Image] → 
[Save Image]

[CLIP Text Encode (Negative)] ↗
[Empty Latent Image (2048x1024)] ↗
```

### Key Nodes

1. **Empty Latent Image**: Set to 2048×1024
2. **KSampler**: 30 steps, CFG 7.5
3. **Upscale Image**: 2x with a good upscaler (4k final)

---

## Method 3: Midjourney

Midjourney can create excellent sky panoramas:

### Prompt Format

```
/imagine 360 degree equirectangular panorama of [SCENE], 
hdri, seamless, --ar 2:1 --v 6 --style raw
```

### Examples

```
/imagine 360 degree equirectangular panorama of an apocalyptic 
red sky with distant burning mountains, hdri, seamless, 
ominous atmosphere --ar 2:1 --v 6 --style raw
```

```
/imagine 360 degree equirectangular panorama of deep space 
with colorful nebulae and distant galaxies, cosmic void, 
hdri, seamless --ar 2:1 --v 6 --style raw
```

### Tips

- Use `--style raw` for less stylized results
- `--ar 2:1` is crucial for correct aspect ratio
- Upscale your favorite with `U1-U4`

---

## Method 4: DALL-E 3 / ChatGPT

DALL-E can create panoramic images but may need editing:

### Prompt

```
Create a 360 degree equirectangular panorama image for use 
as a virtual reality sky. The scene should show [DESCRIPTION]. 
Make sure the left and right edges can seamlessly connect. 
Dramatic, atmospheric lighting.
```

### Note

DALL-E's aspect ratio options are limited. You may need to:
1. Generate a wide image
2. Extend/edit in Photoshop or GIMP
3. Ensure edges match for seamless wrapping

---

## Post-Processing Tips

### Making Edges Seamless

If your generated image has visible seams when wrapped:

1. **Offset Method**:
   - In Photoshop/GIMP: Filter → Other → Offset
   - Offset by half the width
   - Use healing brush on the now-visible center seam
   - Offset back

2. **Clone Stamp**:
   - Work on the edges
   - Clone from similar areas
   - Blend carefully

### Color Matching

For each sky, you need matching colors for the scene:

```javascript
{
  id: 'sky-yoursky',
  name: 'Your Sky Name',
  fog: '#xxxxxx',     // Sample a dark color from horizon
  ambient: '#xxxxxx', // Mid-tone from sky
  sun: '#xxxxxx',     // Brightest light source color
  sunIntensity: 0.6,  // Adjust based on brightness
  ground: '#xxxxxx'   // Dark version of ambient
}
```

**Quick Method**: Use a color picker on your sky image:
- Fog: Darkest area near horizon
- Ambient: Average sky color
- Sun: Brightest spot
- Ground: Darker, desaturated version of ambient

---

## Organizing Your Skies

### File Naming

```
skies/
  blood-dawn.jpg
  alien-twilight.jpg
  void-approaching.jpg
  crystal-cavern.jpg
  your-custom-sky.jpg
```

### Mood Categories

Consider creating skies for different moods:

| Category | Colors | Feeling |
|----------|--------|---------|
| Dawn | Reds, oranges | Hope, danger |
| Night | Deep blues, black | Mystery, peace |
| Storm | Purples, grays | Tension, drama |
| Alien | Greens, cyans | Wonder, otherness |
| Void | Black, minimal | Existential, final |

---

## Performance Considerations

### File Size

- Large skies (4K) can be 2-10MB each
- For web: Use JPG at 80-90% quality
- For fast loading: Consider 2K versions

### Loading Strategy

The `with-sky-images.html` file preloads all images. If you have many:

```html
<a-assets timeout="60000"> <!-- Increase timeout -->
  <img id="sky-1" src="skies/low-res/sky-1.jpg"> <!-- Use smaller versions -->
</a-assets>
```

### Progressive Enhancement

The code falls back to color skies if images don't load—your experience will still work even if images are missing or slow to load.

---

## Inspiration

### Color Palettes to Try

- **Solarpunk**: Warm oranges, living greens
- **Cosmic Horror**: Deep purples, sickly greens
- **Vaporwave**: Pinks, cyans, sunset gradients
- **Post-Apocalyptic**: Ash grays, ember oranges
- **Underwater**: Deep blues, bioluminescent accents
- **Desert**: Warm tans, blazing whites
- **Arctic**: Cold blues, aurora greens

### Reference Artists

Look at work by:
- Simon Stålenhag (sci-fi landscapes)
- Zdzisław Beksiński (surreal, dark)
- Moebius (otherworldly vistas)
- Caspar David Friedrich (romantic sublime)

---

## Sharing Your Skies

If you create beautiful skies, consider sharing them! The Infinite Forward project is public domain—your contributions help everyone build more immersive worlds.

---

*Happy generating. The skies are waiting for you to dream them into existence.*
